﻿var logs = {
    context: $(".v-logs"),
    datatable: null,
    refreshDataTable: function () {
        logs.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-logsTable", logs.context).a4datatable({
            height: "full",
            stateKey: "Logs",
            ajaxAction: a4.getAction("GetLogs", "Diagnostics", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id", "Type": "numeric" },
                { "Name": "Date", "Title": resources.Date, "Data": "Date", "Type": "datetime" },
                { "Name": "LevelName", "Title": resources.Level, "Data": "LogLevel", "Type": "enum", "EnumType": "LogLevelType" },
                { "Name": "MachineName", "Title": resources.Server, "Data": "Server" },
                { "Name": "ApplicationName", "Title": resources.Application, "Data": "Application" },
                { "Name": "ClientId", "Title": resources.ClientId, "Data": "ClientId", "Type": "numeric" },
                { "Name": "UserId", "Title": resources.UserId, "Data": "UserId", "Visible": false, "Type": "numeric" },
                { "Name": "SurveyId", "Title": resources.SurveyId, "Data": "SurveyId", "Visible": false, "Type": "numeric" },
                { "Name": "PanelId", "Title": resources.PanelId, "Data": "PanelId", "Visible": false, "Type": "numeric" },
                { "Name": "ItemId", "Title": resources.ItemId, "Data": "ItemId", "Visible": false, "Type": "numeric" },
                { "Name": "Message", "Title": resources.Message, "Data": "Message", "Width": "30%", "Sortable": false, "EncodeHtml": true },
                { "Name": "Action", "Title": resources.Action, "Data": "Action", "Sortable": false, "Visible": false, "EncodeHtml": true },
                { "Name": "StackTrace", "Title": resources.StackTrace, "Data": "StackTrace", "Sortable": false, "Width": "30%", "Visible": false, "EncodeHtml": true }
            ],
            localizableTexts: { "Search": resources.SearchLogs },
            defaultSorting: { Column: "Id", Ascending: false },
            advancedFilter: true,
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            pagingType: "input"
        });
    },
    bindEvents: function () {
        logs.context.on("click", ".h-exportLogs", function () {
            var tableParams = logs.datatable.a4datatable("getTableParams");
            var link = a4.getAction("ExportLogs", "Diagnostics", "Settings", { tableParams: JSON.stringify(tableParams) });
            a4.showBusyBox();

            a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetExportLogsFile", "Diagnostics", "Settings", { filename: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });

        logs.context.on("click", ".h-clearLogs", function () {
            modalDialog.showConfirmDialog(confirmClearLogsResources, function () {
                a4.callServerMethod(a4.getAction("ClearLogs", "Diagnostics", "Settings"), {},
                    function (result) {
                        logs.refreshDataTable();
                    });
            }, 220, 500);
        });
    }
}

$(document).ready(function () {
    if (logs.context.length > 0) {
        logs.initializeDataTable();
        logs.bindEvents();
    }
});


